package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户与组织关联表返回vo
 *
 * @author zxw
 * @date 2020-12-21 09:50:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户与组织关联表")
@SaturnEntity(name = "MdmCustomerROrgRespVo", description = "客户与组织关联表")
public class MdmCustomerROrgRespVo extends CrmExtTenVo {

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

}