package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 货补费用池使用金额明细请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolGoodsUseItemReqVo", description = "货补费用池使用金额明细请求VO")
@AllArgsConstructor
@NoArgsConstructor
@Deprecated
public class FeePoolGoodsUseItemReqVo {

    @ApiModelProperty("费用池编号（必填）")
    private String poolCode;

    @ApiModelProperty("商品编码（必填）")
    private String productCode;

    @ApiModelProperty("使用金额（必填）")
    private BigDecimal amount;

}