package com.biz.crm.nebular.mdm.kms;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsBaseVo;
import com.biz.crm.nebular.mdm.kms.api.KmsStoreVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalTime;
import java.util.List;

/**
 * @author zxw
 * @date 2021-02-19 13:52
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@CrmColumnResolve
public class MdmGrabRuleVo extends PageVo {

    @ApiModelProperty("客户帐号")
    private String loginAcc;

    @ApiModelProperty("客户密码")
    private String loginPass;

    @ApiModelProperty("状态")
    private String enableStatus;

    @ApiModelProperty("状态名称")
    private String enableStatusName;

    @ApiModelProperty("规则名称")
    private String name;

    private String accountId;

    @ApiModelProperty("运营管理后台直营体系id")
    private String bsDirectId;

    @ApiModelProperty("运营管理后台单据类型id")
    private String bsInvoiceId;

    @ApiModelProperty("直营体系名称")
    private String directSystemName;

    @ApiModelProperty("直营体系id")
    private String directSystemId;

    @ApiModelProperty("单据类型名称")
    private String invoiceName;

    @ApiModelProperty("单据类型id")
    private String invoiceId;

    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("结束时间")
    private String endDate;

    @ApiModelProperty("是否客户所有门店")
    private boolean kmsAllStore;

    @ApiModelProperty("选择门店id集合")
    private List<KmsStoreVo> stores;

    @ApiModelProperty("规则参数")
    private List<MdmGrabParamVo> params;

    @ApiModelProperty("间隔时间")
    private String requency;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("参数列表返回")
    List<MdmRuleParamVo> mdmRuleParamVos;
}
