package com.biz.crm.nebular.sfa.checkin.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 签到组保存;请求vo
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaCheckInGroupReqVo", description = "签到组;")
public class SfaCheckInGroupSaveReqVo extends CrmExtTenVo {

    @ApiModelProperty("签到组名称")
    private String groupName;

    @ApiModelProperty("打卡日期集合")
    private List<SfaCheckInDateReqVo> dateReqVos;

    @ApiModelProperty("打卡类型集合")
    private List<SfaCheckInGroupTypeReqVo> groupTypeReqVos;

    @ApiModelProperty("打卡组织集合")
    private List<SfaCheckInOrgReqVo> orgReqVos;

    @ApiModelProperty("打卡人员集合")
    private List<SfaCheckInUserReqVo> userReqVos;

    @ApiModelProperty("打卡地址集合")
    private List<SfaCheckInPlaceReqVo> placeReqVos;

    @ApiModelProperty("有效时间类型")
    private String timeType;

    @ApiModelProperty("电子围栏类型")
    private String electronFenceType;

}