package com.biz.crm.nebular.sfa.collection.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 拜访步骤配置(角色) 请求vo
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitRoleConfigReqVo", description = "拜访步骤配置(角色) ")
public class SfaVisitRoleConfigReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访id")
    private String visitId;

    @ApiModelProperty("拜访步骤配置(角色)编码 拜访步骤配置(角色)编码")
    private String visitRoleCode;

    @ApiModelProperty("角色编码 角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称 角色名称")
    private String roleName;

    @ApiModelProperty("拜访类型 拜访类型")
    private String visitType;

    @ApiModelProperty("客户类型 客户类型")
    private String sfacusType;

    @ApiModelProperty("拜访人员账号")
    private String visitUserName;

    @ApiModelProperty("职位编码")
    private String visitPosCode;

    @ApiModelProperty("拜访步骤配置(角色) 角色")
    private List<SfaVisitRoleReqVo> visitRoleReqVos;

    @ApiModelProperty("拜访步骤配置(角色) 拜访步骤表单配置")
    private List<SfaVisitRoleDirectoryReqVo> visitRoleDirectoryReqVos;

    @ApiModelProperty("拜访步骤配置(角色)编码集合 拜访步骤配置(角色)编码集合")
    private List<String> visitRoleCodes;

    @ApiModelProperty("角色编码集合")
    private List<String> roleCodeList;

}