package com.biz.crm.nebular.dms.promotion;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;


/**
 * 促销政策编辑页面数据查询VO
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PromotionPolicyForOrderProductReqVo implements Serializable {

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 促销政策编码
     */
    private String promotionCode;


    public static PromotionPolicyForOrderProductReqVo newInstance(String productCode,String promotionCode){
        PromotionPolicyForOrderProductReqVo vo = new PromotionPolicyForOrderProductReqVo();
        vo.setProductCode(productCode);
        vo.setPromotionCode(promotionCode);
        return vo;
    }

}
