package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 货补费用池按照（产品层级）使用金额明细请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolGoodsUseByProductLevelItemReqVo", description = "货补费用池按照（产品层级）使用金额明细请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class FeePoolGoodsUseByProductLevelItemReqVo {

    @ApiModelProperty("产品层级编码（必填）")
    private String productLevelCode;

    @ApiModelProperty("使用金额（必填）")
    private BigDecimal amount;

}