package com.biz.crm.nebular.fee.pool.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 费用池金额查询返回VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池金额查询返回VO")
public class FeePoolAmountQueryRespVo {

    @ApiModelProperty("客户折扣费用可用余额")
    private BigDecimal discountUsableAmount;

    @ApiModelProperty("费用池编号对应可用余额")
    private Map<String, BigDecimal> poolUsableAmountMap;

}