package com.biz.crm.nebular.sfa.checkin.resp;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组-签到记录返回vo
 *
 * @author fily
 * @date 2021-01-05 13:12:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "签到组-签到记录")
@SaturnEntity(name = "SfaCheckInSignRecordRespVo", description = "签到组-签到记录")
public class SfaCheckInSignRecordRespVo {

    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("签到组编码")
    @SaturnColumn(description = "签到组编码")
    private String groupCode;

    @ApiModelProperty("签到组名称")
    @SaturnColumn(description = "签到组名称")
    private String groupName;

    @ApiModelProperty("签到日期id")
    @SaturnColumn(description = "签到日期id")
    private String checkInDateId;

    @ApiModelProperty("打卡类型id")
    @SaturnColumn(description = "打卡类型id")
    private String checkInTypeId;

    @ApiModelProperty("打卡类型名称")
    @SaturnColumn(description = "打卡类型名称")
    private String checkInTypeName;

    @ApiModelProperty("签到人员帐号")
    @SaturnColumn(description = "签到人员帐号")
    private String userName;

    @ApiModelProperty("签到人员名称")
    @SaturnColumn(description = "签到人员名称")
    private String realName;

    @ApiModelProperty("人员职位编码")
    @SaturnColumn(description = "人员职位编码")
    private String posCode;

    @ApiModelProperty("人员职位名称")
    @SaturnColumn(description = "人员职位名称")
    private String posName;

    @ApiModelProperty("人员组织编码")
    @SaturnColumn(description = "人员组织编码")
    private String orgCode;

    @ApiModelProperty("人员组织名称")
    @SaturnColumn(description = "人员组织名称")
    private String orgName;

    @ApiModelProperty("人员上级组织编码")
    @SaturnColumn(description = "人员上级组织编码")
    private String parentOrgCode;

    @ApiModelProperty("人员上级组织名称")
    @SaturnColumn(description = "人员上级组织名称")
    private String parentOrgName;

    @ApiModelProperty("打卡时间(HH:mm:ss)")
    @SaturnColumn(description = "打卡时间(HH:mm:ss)")
    private String signTime;

    @ApiModelProperty("打卡日期(YYYY-MM-DD)")
    @SaturnColumn(description = "打卡日期(YYYY-MM-DD)")
    private String signDate;

    @ApiModelProperty("打卡经度")
    @SaturnColumn(description = "打卡经度")
    private String lngIn;

    @ApiModelProperty("打卡纬度")
    @SaturnColumn(description = "打卡纬度")
    private String latIn;

    @ApiModelProperty("考勤地点")
    @SaturnColumn(description = "考勤地点")
    private String signPlace;

    @ApiModelProperty("打卡照片")
    List<SfaCheckInSignRecordPictureRespVo> pictureRespVoList;

    @ApiModelProperty("备注")
    private String remarks;

}