package com.biz.crm.nebular.sfa.customer.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户库存记录响应vo
 *
 * @author yangshan
 * @date 2021-3-4 21:15:56
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaCustomerInventoryRecordsRespVo", description = "客户库存记录")
public class SfaCustomerInventoryRecordsRespVo extends CrmExtTenVo {

    /**
     * 库存记录
     */
    @ApiModelProperty("最近一次盘库时间")
    private String stockTime;

    /**
     * 库存数量
     */
    @ApiModelProperty("库存数量")
    private String quantity;

    /**
     * 库存差
     */
    @ApiModelProperty("库存差")
    private String quantityDifference;

    /**
     * 系列数
     */
    @ApiModelProperty("系列数")
    private String seriesNum;

    /**
     * 商品种类总数
     */
    @ApiModelProperty("商品种类总数")
    private String typeNum;
}