package com.biz.crm.nebular.sfa.worksign.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 出差申请 请求vo
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaTravelReqVo", description = "出差申请 ")
public class SfaTravelReqVo extends CrmExtTenVo {

    @ApiModelProperty("申请人员账号 申请人员账号")
    private String applyUserName;

    @ApiModelProperty("申请人员姓名 申请人员姓名")
    private String applyRealName;

    @ApiModelProperty("申请职位编码 申请职位编码")
    private String applyPosCode;

    @ApiModelProperty("申请职位名称 申请职位名称")
    private String applyPosName;

    @ApiModelProperty("申请所属组织编码 申请所属组织编码")
    private String applyOrgCode;

    @ApiModelProperty("申请所属组织名称 申请所属组织名称")
    private String applyOrgName;

    @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd)")
    private String endTime;

    @ApiModelProperty("出差地点 出差地点")
    private String address;

    @ApiModelProperty("出差目的 出差目的")
    private String travelObjective;

    @ApiModelProperty("审批状态 审批状态")
    private String bpmStatus;


    private String myApply;

    /**
     * 时间范围查询（日期组）
     */
    @ApiModelProperty("申请日期-开始(yyyy-MM-dd)")
    private String applicationDateStart;

    @ApiModelProperty("申请日期-结束(yyyy-MM-dd)")
    private String applicationDateEnd;

    @ApiModelProperty("开始时间-开始(yyyy-MM-dd)")
    private String beginTimeStart;

    @ApiModelProperty("开始时间-结束(yyyy-MM-dd)")
    private String beginTimeEnd;

    @ApiModelProperty("结束时间-开始(yyyy-MM-dd)")
    private String endTimeStart;

    @ApiModelProperty("结束时间-结束(yyyy-MM-dd)")
    private String endTimeEnd;

    @ApiModelProperty("考勤审核类型(1待审核，2已审批)")
    private String auditType;

    @ApiModelProperty("审核任务id集合")
    List<String> auditTaskIdList;

    private String travelUserNames;

    private String yearMonth;

}