package com.biz.crm.nebular.dms.salecontract;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 合同元组vo
 * @Author: chenrong
 * @Date: 2021/2/5 10:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同元组vo")
public class ContractTupleVo extends CrmExtTenVo {

  private static final long serialVersionUID = 185949623137667884L;
  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;
  /**
   * 名称
   */
  @ApiModelProperty(value = "名称")
  private String name;
  /**
   * 前端项目中的相对路径
   */
  @ApiModelProperty(value = "前端项目中的相对路径")
  private String relativePath;
  /**
   * 前端路由路径
   */
  @ApiModelProperty(value = "前端路由路径")
  private String routerPath;
  /**
   * 对象字段名
   */
  @ApiModelProperty(value = "对象字段名")
  private String jsonName;
  /**
   * 逻辑处理bean（该模块数据保存和查询）名称
   */
  @ApiModelProperty(value = "逻辑处理bean（该模块数据保存和查询）名称")
  private String beanName;
  /**
   * 元组在模板中的展示顺序
   */
  @ApiModelProperty(value = "元组在模板中的展示顺序")
  private Integer tupleIndex = 100;
  /**
   * 页面编码
   */
  @ApiModelProperty(value = "页面编码")
  private String pageCode;
  /**
   * 功能编码
   */
  @ApiModelProperty(value = "功能编码")
  private String functionCode;
  /**
   * 冗余字段：模板编码
   */
  @ApiModelProperty(value = "冗余字段：模板编码")
  private String templateCode;
  /**
   * 数据检索编码
   */
  @ApiModelProperty(value = "数据检索编码")
  private String indexCode;
  /**
   * 富文本内容保存字段，主要用于设置合同细则和违约责任等固定数据
   */
  @ApiModelProperty(value = "富文本内容保存字段，主要用于设置合同细则和违约责任等固定数据")
  private String context;
}
