package com.biz.crm.nebular.dms.salecontract;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.nebular.dms.contractupdatingfiles.ContractUpdatingFilesVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 合同vo
 * @Author: chenrong
 * @Date: 2021/2/17 11:31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同vo")
public class SaleContractVo extends CrmExtVo {

  /**
   * 合同编码
   */
  @ApiModelProperty(value = "合同编码")
  private String code;
  /**
   * 合同名称
   */
  @ApiModelProperty(value = "合同名称")
  private String name;
  /**
   * 模板编码
   */
  @ApiModelProperty(value = "模板编码")
  private String templateCode;
  /**
   * 合同类型
   */
  @ApiModelProperty(value = "合同类型")
  private String contractType;
  /**
   * 合同年度
   */
  @ApiModelProperty(value = "合同年度")
  private String yearly;
  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String cusCode;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String cusName;
  /**
   * 渠道类型
   */
  @ApiModelProperty(value = "渠道类型")
  private String channelCode;
  /**
   * 渠道名称
   */
  @ApiModelProperty(value = "渠道名称")
  private String channelName;
  /**
   * 所属组织编码
   */
  @ApiModelProperty(value = "所属组织编码")
  private String orgCode;
  /**
   * 所属组织名称
   */
  @ApiModelProperty(value = "所属组织名称")
  private String orgName;
  /**
   * 合同开始时间
   */
  @ApiModelProperty(value = "合同开始时间")
  private String startTime;
  /**
   * 合同结束时间
   */
  @ApiModelProperty(value = "合同结束时间")
  private String endTime;
  /**
   * 各个模块的json数据
   */
  @ApiModelProperty(hidden = true)
  private JSONObject data;
  /**
   * 合同模板对象
   */
  @ApiModelProperty(value = "合同模板对象")
  private ContractTemplateVo contractTemplateVo;
  /**
   * 冗余字段：文件列表
   */
  @ApiModelProperty(value = "冗余字段：文件列表")
  private List<ContractUpdatingFilesVo> filesVo;
  /**
   * 签约状态
   */
  @ApiModelProperty(value = "签约状态")
  private Integer signState = 0;



  /*******/
  /**
   * 对接人
   */
  @ApiModelProperty(value = "对接人")
  private String dockingPeople;
  /**
   * 客户法律代表
   */
  @ApiModelProperty(value = "客户法律代表")
  private String cusLegalRepresentative;
  /**
   * 客户联系方式
   */
  @ApiModelProperty(value = "客户联系方式")
  private String cusContact;
  /**
   * 省编码
   */
  @ApiModelProperty(value = "省编码")
  private String provinceCode;
  /**
   * 省
   */
  @ApiModelProperty(value = "省")
  private String province;
  /**
   * 市编码
   */
  @ApiModelProperty(value = "市编码")
  private String cityCode;
  /**
   * 市
   */
  @ApiModelProperty(value = "市")
  private String city;
  /**
   * 区县编码
   */
  @ApiModelProperty(value = "区县编码")
  private String districtCode;
  /**
   * 区县
   */
  @ApiModelProperty(value = "区县")
  private String district;

}
