package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池明细表日志分页列表查询请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDetailLogPageReqVo", description = "费用池明细表日志分页列表查询请求VO")
public class FeePoolDetailLogPageReqVo extends CrmBaseVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("操作时间 yyyy-MM-dd HH:mm:ss")
    private String operationDateTime;

    @ApiModelProperty("操作金额（元）（含正负）")
    private BigDecimal operationAmount;

    @ApiModelProperty("使用商品或层级编码")
    private String productCode;

    @ApiModelProperty("使用商品或层级名称")
    private String productName;

    @ApiModelProperty("（主表维度）客户编码")
    private String customerCode;

    @ApiModelProperty("（主表维度）客户名称")
    private String customerName;

    @ApiModelProperty("（主表维度）费用池类型")
    private String poolType;

    @ApiModelProperty("（主表维度）支付方式")
    private String payType;

    @ApiModelProperty("（主表维度）折扣费用池类型")
    private String discountType;

    @ApiModelProperty("（主表维度）货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("（主表维度）货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("（主表维度）货补商品编码(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("（主表维度）货补商品名称(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

}