package com.biz.crm.nebular.mdm;


import com.biz.crm.config.CrmDict;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 基本字段entity，用于每个表
 * @Author: zhangyuzhu
 * @Date: 2020/8/19 10:01
 **/
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Data
public class CrmBaseVo extends PageVo {
    private static final long serialVersionUID = 1L;
//    /**
//     * 主键
//     */
//    private String id;

    /**
     * 数据状态（删除状态）
     */
    @SaturnColumn(description = "数据状态（删除状态）")
    private String delFlag;

    /**
     * 数据业务状态（启用状态）
     */
    @ApiModelProperty("生效状态 003停用，009启用")
    @SaturnColumn(description = "生效状态")
    private String enableStatus;

    /**
     * 数据业务状态名称（启用状态）
     */
    @ApiModelProperty("生效状态名称")
    @SaturnColumn(description = "生效状态名称")
//    @CrmSetVal(targetClass = "com.biz.crm.eunm.CrmEnableStatusEnum",paramField = "enableStatus",targetField = "mdmEnableStatusName",targetMethod = "getDesc")
    @CrmDict(typeCode = "enable_status",dictCodeField = "enableStatus")
    private String enableStatusName;
    /**
     * 创建时间 yyyy-mm-dd
     */
    @ApiModelProperty("创建日期")
    @SaturnColumn(description = "创建日期")
    private String createDate;
    /**
     * 创建时间 hh:mm:ss
     */
    @ApiModelProperty("创建时间")
    @SaturnColumn(description = "创建时间")
    private String createDateSecond;

    /**
     * 创建人账号
     */
    @SaturnColumn(description = "创建人账号")
    private String createCode;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    @SaturnColumn(description = "创建人名称")
    private String createName;

    /**
     * 创建人组织编码
     */
    @SaturnColumn(description = "创建人组织编码")
    private String createOrgCode;

    /**
     * 创建人组织名称
     */
    @ApiModelProperty("创建人组织名称")
    @SaturnColumn(description = "创建人组织名称")
    private String createOrgName;

    /**
     * 创建人职位code
     */
    @SaturnColumn(description = "创建人职位编码")
    private String createPosCode;

    /**
     * 创建人职位名称
     */
    @SaturnColumn(description = "创建人职位名称")
    private String createPosName;

    /**
     * 修改时间 yyyy-mm-dd
     */
    @ApiModelProperty("修改日期")
    @SaturnColumn(description = "修改日期")
    private String updateDate;

    /**
     * 更新时间 hh:mm:ss
     */
    @ApiModelProperty("修改时间")
    @SaturnColumn(description = "修改时间")
    private String updateDateSecond;

    /**
     * 修改人账号
     */
    @SaturnColumn(description = "修改人账号")
    private String updateCode;

    /**
     * 修改人名称
     */
    @ApiModelProperty("修改人名称")
    @SaturnColumn(description = "修改人名称")
    private String updateName;

    /**
     * 修改人组织编码
     */
    @SaturnColumn(description = "修改人组织编码")
    private String updateOrgCode;

    /**
     * 修改人组织名称
     */
    @SaturnColumn(description = "修改人组织名称")
    private String updateOrgName;

    /**
     * 修改人职位code
     */
    @SaturnColumn(description = "修改人职位编码")
    private String updatePosCode;

    /**
     * 修改人职位名称
     */
    @SaturnColumn(description = "修改人职位名称")
    private String updatePosName;
    /**
     * 备注
     */
    @SaturnColumn(description = "备注")
    private String remarks;
    @ApiModelProperty("修改时间完整")
    private String updateDateAll;
    @ApiModelProperty("创建时间完整")
    private String createDateAll;

    @ApiModelProperty("当前登录用户")
    private String username;

    public String getUpdateDateAll() {
        return (StringUtils.isNotEmpty(updateDate) ? updateDate + " " : "") + (StringUtils.isNotEmpty(updateDateSecond) ? updateDateSecond : "");
    }

    public String getCreateDateAll() {
        return (StringUtils.isNotEmpty(createDate) ? createDate + " " : "") + (StringUtils.isNotEmpty(createDateSecond) ? createDateSecond : "");
    }
}
