package com.biz.crm.nebular.sfa.visitstep.req;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 拜访步骤表单-新增编辑Vo
 * @author YuanZiJian
 * @date 2021/2/5 12:23
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤表单-新增编辑")
@SaturnEntity(name = "SfaVisitStepFromReqVo", description = "拜访步骤表单-新增编辑")
public class SfaVisitStepFromReqVo {
    @ApiModelProperty("步骤表单Id——新增无需传入Id")
    private String id;
    /**
     * 步骤表单名称
     */
    @ApiModelProperty("步骤表单名称")
    private String fromName;
    /**
     * 拜访类型
     */
    @ApiModelProperty("拜访类型")
    private String visitType;

    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    private String customerType;

    /**
     * 有效期类型
     */
    @ApiModelProperty("有效期类型")
    private String timeType;
    /**
     * 有效期开始时间
     */
    @ApiModelProperty("有效期开始时间")
    private String startTime;
    /**
     * 有效期结束时间
     */
    @ApiModelProperty("有效期结束时间")
    private String endTime;
    /**
     * 步骤logo
     */
    @ApiModelProperty("步骤logo")
    private List<SfaVisitStepIconReqVo> icon;
    /**
     * 页面编码——（模板）
     */
    @ApiModelProperty("页面编码——（即模板）")
    private String pageCode;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("拜访步骤模块-新增编辑Vo")
    private List<SfaVisitStepFromModelReqVo> StepFromModelReqVoList;

    /**
     * 步骤编码
     */
    @ApiModelProperty("步骤编码")
    private String stepCode;
}
