package com.biz.crm.nebular.log.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/18 17:44
 **/
@ApiModel("日志模板对象")
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class LogTemplateVo implements Serializable {

    @ApiModelProperty("id主键")
    private String id;

    @ApiModelProperty("业务模块编码(菜单编码)")
    private String menuCode;

    @ApiModelProperty("业务模型名称(可同菜单名称)")
    private String businessName;

    @ApiModelProperty("模板类全路径")
    private String typeClassPath;

    @ApiModelProperty("模块编码")
    private String moduleCode;

    @ApiModelProperty(value = "字段列表")
    private List<LogFieldVo> fieldList;

    @ApiModelProperty("是否启用（字典）")
    private Integer enableFlag;

    @ApiModelProperty("每页数据的数量（默认25）")
    private Integer pageSize=25;

    @ApiModelProperty("页码(默认1)")
    private Integer pageNum=1;
}
