package com.biz.crm.nebular.mdm.mdmbuglistmanagement.req;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * bug管理主表请求vo
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmBugListManagementReqVo", description = "bug管理主表")
public class MdmBugListManagementReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("禅道bug编号")
    private String bugCode;

    @ApiModelProperty("bug名称")
    private String bugName;

    @ApiModelProperty("bug负责人")
    private String chargeMan;

    @ApiModelProperty("手机号（@标识）")
    private String codeByPhone;

    @ApiModelProperty("是否已完成(发布到远程仓库后,该字段值为Y,默认为N)")
    private String isComplete;

    @ApiModelProperty("是否已完成(发布到远程仓库后))")
    private String isCompleteDesc;

    @ApiModelProperty("后端是否已解决(Y,N)")
    private String isBackendFix;

    @ApiModelProperty("后端是否已解决(是,否)")
    private String isBackendFixDesc;

    @ApiModelProperty("前端是否已解决(Y,N)")
    private String isForeEndFix;

    @ApiModelProperty("前端是否已解决")
    private String isForeEndFixDesc;

    @ApiModelProperty("是否dev测试中(Y,N)")
    private String isDevTesting;

    @ApiModelProperty("是否dev测试中")
    private String isDevTestingDesc;

    @ApiModelProperty("dev是否测试通过(Y,N)")
    private String isDevPassTest;

    @ApiModelProperty("dev是否测试通过")
    private String isDevPassTestDesc;

    @ApiModelProperty("后端是否已部署(Y,N)")
    private String isBackendArrUat;

    @ApiModelProperty("后端是否已部署")
    private String isBackendArrUatDesc;

    @ApiModelProperty("前端是否已部署uat(Y,N)")
    private String isForeEndArrUat;

    @ApiModelProperty("前端是否已部署uat")
    private String isForeEndArrUatDesc;

    @ApiModelProperty("uat 测试中(Y,N)")
    private String isUatTesting;

    @ApiModelProperty("uat 测试中")
    private String isUatTestingDesc;

    @ApiModelProperty("uat 测试通过(Y,N)")
    private String isUatPassTest;

    @ApiModelProperty("uat 测试通过")
    private String isUatPassTestDesc;

    @ApiModelProperty("后端是否已部署 pro(Y,N)")
    private String isBackendArrPro;

    @ApiModelProperty("后端是否已部署 pro")
    private String isBackendArrProDesc;

    @ApiModelProperty("前端是否已部署(Y,N)")
    private String isForeEndArrPro;

    @ApiModelProperty("前端是否已部署")
    private String isForeEndArrProDesc;

    @ApiModelProperty("pro 测试中(Y,N)")
    private String isProTesting;

    @ApiModelProperty("pro 测试中")
    private String isProTestingDesc;

    @ApiModelProperty("pro测试通过")
    private String isProPassTest;

    @ApiModelProperty("pro测试通过")
    private String isProPassTestDesc;

    @ApiModelProperty("待发布")
    private String isWaitComplete;

    @ApiModelProperty("dev 待测试")
    private String isDevWaitTest;

    @ApiModelProperty(" uat 待测试")
    private String isUatWaitTest;

    @ApiModelProperty("pro 待测试")
    private String isProWaitTest;

    /**
     * 是否紧急
     */
    @ApiModelProperty("是否紧急 (Y,N)")
    private String isUrgent;
    @ApiModelProperty("是否紧急")
    private String isUrgentDesc;
    @ApiModelProperty("禅道链接")
    private String ztUrl;

    @ApiModelProperty("所属模块")
    private String owningModule;

    @ApiModelProperty("待发布时间")
    private String releaseDate;
    @ApiModelProperty("发布版本")
    private String releaseVersion;
    @ApiModelProperty("需要完成时间")
    private String needMissionDate;
}