package com.biz.crm.nebular.mdm.notice.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 公告管理 返回vo
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "公告管理 ")
@SaturnEntity(name = "SfaNoticeRespVo", description = "公告管理 ")
public class MdmNoticeRespVo extends CrmBaseVo {

    @ApiModelProperty("公告编码 公告编码")
    @SaturnColumn(description = "公告编码 公告编码")
    private String noticeCode;

    @ApiModelProperty("公告标题 公告标题")
    @SaturnColumn(description = "公告标题 公告标题")
    private String noticeTitle;

    @ApiModelProperty("公告类型 公告类型")
    @SaturnColumn(description = "公告类型 公告类型")
    private String noticeType;

    @ApiModelProperty("公告类型描述 公告类型描述")
    @CrmDict(typeCode = "noticeType",dictCodeField = "noticeType")
    private String noticeTypeDesc;

    @ApiModelProperty("有效开始时间 有效开始时间")
    @SaturnColumn(description = "有效开始时间 有效开始时间")
    private String beginDate;

    @ApiModelProperty("有效结束时间 有效结束时间")
    @SaturnColumn(description = "有效结束时间 有效结束时间")
    private String endDate;

    @ApiModelProperty("公告内容 公告内容")
    @SaturnColumn(description = "公告内容 公告内容")
    private String noticeContent;

    @ApiModelProperty("发布部门 发布部门")
    @SaturnColumn(description = "发布部门 发布部门")
    private String noticeOrg;

    @ApiModelProperty("发布时间 发布时间")
    @SaturnColumn(description = "发布时间 发布时间")
    private String noticeDate;

    @ApiModelProperty("访问次数 访问次数")
    @SaturnColumn(description = "访问次数 访问次数")
    private Integer visitNum;

    @ApiModelProperty("已读人数 已读人数")
    @SaturnColumn(description = "已读人数 已读人数")
    private Integer readUserNum;

    @ApiModelProperty("公告管理-公告发布范围")
    @SaturnColumn(description = "公告管理-公告发布范围")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<MdmNoticeReceivingRespVo> noticeReceivingRespVos;

    @ApiModelProperty("公告管理-公告附件")
    @SaturnColumn(description = "公告管理-公告附件")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<MdmNoticeFileRespVo> noticeFileRespVos;

    @ApiModelProperty("读取状态 0未读 1已读")
    private String haveRead;

    @ApiModelProperty("创建时间")
    private String createDateTime;

    @ApiModelProperty("修改时间")
    private String updateDateTime;

    @ApiModelProperty("公告发布状态 0未发布 1发布")
    private String noticeReleaseStatus;

    @ApiModelProperty("公告发布状态")
    private String noticeReleaseStatusName;

    @ApiModelProperty("公告置顶状态 0未置顶 1置顶")
    private String noticeTopState;

    @ApiModelProperty("公告置顶状态 未置顶 置顶")
    private String noticeTopStateName;

    @ApiModelProperty("公告评论状态 0不可评论 1可评论")
    private String commentState;

    @ApiModelProperty("公告评论状态 不可评论 可评论")
    private String commentStateName;

    @ApiModelProperty("公告评论-公告评论")
    @SaturnColumn(description = "公告评论-公告评论")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<MdmNoticeCommentRespVo> noticeCommentRespVos;
}