package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 终端用户列表查询请求VO
 * @author ql
 * @date 2021/2/3
 * @time 20:22
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmTerminalUserPageReqVo", description = "终端用户列表查询请求VO")
public class MdmTerminalUserPageReqVo extends CrmExtTenVo {
    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String startTime;

    @ApiModelProperty("失效时间")
    private String endTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态")
    private String lockState;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("列表查询条件：终端编码")
    private String terminalCode;

    @ApiModelProperty("列表查询条件：终端名称")
    private String terminalName;

    @ApiModelProperty("列表查询条件：角色编码")
    private String roleCode;

    @ApiModelProperty("列表查询条件：角色名称")
    private String roleName;

}
