package com.biz.crm.nebular.sfa.approval.resp;

import com.biz.crm.config.CrmDict;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 我的审批列表返回对象
 * @author YuanZiJian
 * @date 2021/3/10 16:37
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "我的审批")
public class SfaApprovalListRespVo  {
    /**
     * 审批类型
     */
    @ApiModelProperty("审批类型")
    private String approvalType;

    /**
     * 审批类型名称
     */
    @ApiModelProperty("审批类型名称")
    @CrmDict(typeCode = "approvalType",dictCodeField = "approvalType")
    private String approvalTypeName;
    /**
     * 发起时间
     */
    @ApiModelProperty("发起时间")
    private String createTime;
    /**
     * 发起人的所属组织
     */
    @ApiModelProperty("发起人的所属组织")
    private String orgName;

    @ApiModelProperty("发起人账号")
    private String startUserCode;

    @ApiModelProperty(value = "发起人姓名")
    private String startUserName;

    /**
     * 对应的业务id
     */
    @ApiModelProperty(value = "对应的业务id")
    private String id;

    @ApiModelProperty(value = "流程实例Id")
    private String processInstanceId;

    @ApiModelProperty(value = "流程编号")
    private String processNo;

    @ApiModelProperty(value = "节点ID")
    private String taskId;

    @ApiModelProperty(value = "审批流程状态:对应数据字典：bpm_status")
    private Integer processState;

    @ApiModelProperty(value = "审批流程状态名称:对应数据字典：bpm_status")
    @CrmDict(typeCode = "bpm_status",dictCodeField = "processState")
    private String processStateName;

    @ApiModelProperty(value = "抄送用——抄送节点状态(1=未读2=已阅)")
    private Integer status;

    @ApiModelProperty(value = "抄送用——抄送节点状态(1=未读2=已阅)")
    @CrmDict(typeCode = "SendStatus",dictCodeField = "status")
    private String  statusName;

    @ApiModelProperty(value = "抄送用——抄送来源人的用户编码")
    private String fromUser;

    @ApiModelProperty(value = "抄送用——抄送来源人的用户名称")
    private String fromUserName;

}
