package com.biz.crm.nebular.tpm.liqueuraudit.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 酒类TPM核销申请主表;返回vo
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类TPM核销申请主表;")
@SaturnEntity(name = "TpmLiqueurAuditRespVo", description = "酒类TPM核销申请主表;")
public class TpmLiqueurAuditRespVo extends CrmExtVo {
    @ApiModelProperty("核销申请名称")
    @SaturnColumn(description = "核销申请名称")
    private String auditName;

    @ApiModelProperty("核销申请编码")
    @SaturnColumn(description = "核销申请编码")
    private String auditCode;

    @ApiModelProperty("审批状态(字典)")
    @SaturnColumn(description = "审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("流程编号")
    @SaturnColumn(description = "流程编号")
    private String processCode;

    @ApiModelProperty("工作流key")
    @SaturnColumn(description = "工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    @SaturnColumn(description = "工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("总金额")
    @SaturnColumn(description = "总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

}