package com.biz.crm.nebular.dms.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.order.vo
 * @Description: TODO
 * @date 2021/1/29 下午2:35
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单行分组vo")
public class OrderGroupItemVo implements Serializable {
    @ApiModelProperty(value = "本品")
    private List<OrderDetailVo> normalList;
    @ApiModelProperty(value = "赠品")
    private List<OrderDetailVo> giftList;
    @ApiModelProperty(value = "货补")
    private List<OrderDetailVo> backList;

    @ApiModelProperty(value = "分组编码")
    private String groupCode;

    /**
     * 该组优惠金额
     */
    private BigDecimal promotionAmount;

}
