package com.biz.crm.nebular.mdm.product.req;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商品主表请求vo
 *
 * @author crm
 * @date 2020-08-27 16:29:10
 */
@Data
@Accessors(chain = true)
@CrmColumnResolve
@EqualsAndHashCode(callSuper = false)
public class MdmProductReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("商品类型(数据字典:product_type)")
    private String productType;

    @ApiModelProperty("销售单位")
    private String saleUnit;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("销售公司")
    private String saleCompany;

    @ApiModelProperty("基本单位")
    private String baseUnit;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;


    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("上下架状态(数据字典:is_shelf)")
    private String isShelf;

    @ApiModelProperty("条形码")
    private String barCode;

    @ApiModelProperty("物料信息")
    private List<MdmProductMaterialReqVo> materialList;

    @ApiModelProperty("图片信息")
    private List<MdmProductMediaRespVo> pictureList;

    @ApiModelProperty("视频信息")
    private List<MdmProductMediaRespVo> videoList;

    @ApiModelProperty("富文本信息")
    private MdmProductIntroductionReqVo introductionVo;

    @ApiModelProperty("产品层级公共树编码")
    private String code;

    @ApiModelProperty("是否维护图片1是0否")
    private String maintenancePicture;

    @ApiModelProperty("是否维护详情1是0否")
    private String maintenanceIntroduction;
}