package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 拜访步骤(订单主表);请求vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepOrderReqVo", description = "拜访步骤(订单主表);")
public class SfaVisitStepOrderReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("订单编码")
    private String orderCode;

    @ApiModelProperty("下单时间")
    private String orderTime;

    @ApiModelProperty("拜访编码")
    private String visitId;

    @ApiModelProperty("网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;

    @ApiModelProperty("网点图片")
    private String clientPhoto;

    @ApiModelProperty("上级客户编码")
    private String customerCode;

    @ApiModelProperty("上级客户名称")
    private String customerName;

    @ApiModelProperty("联系人")
    private String contacts;

    @ApiModelProperty("联系电话")
    private String telephone;

    @ApiModelProperty("收货地址")
    private String address;

    @ApiModelProperty("期望收货时间")
    private String expectReceive;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("开始时间")
    private String startOrderTime;

    @ApiModelProperty("结束时间")
    private String endOrderTime;

    @ApiModelProperty("审批状态")
    private String approvalStatus;

    @ApiModelProperty("订单来源")
    private String orderSource;

    @ApiModelProperty("订单总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("方案执行id")
    private String actExecuteId;

    @ApiModelProperty("产品明细")
    private List<SfaVisitStepOrderItemReqVo> sfaVisitStepOrderItems;
}