package com.biz.crm.nebular.sfa.worksign.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 出差人员表 返回vo
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "出差人员")
@SaturnEntity(name = "SfaTravelUserRespVo", description = "出差人员")
public class SfaTravelUserRespVo {

    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("出差申请id 出差申请id")
    @SaturnColumn(description = "出差申请id 出差申请id")
    private String travelId;

    @ApiModelProperty("人员账号 人员账号")
    @SaturnColumn(description = "人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员姓名 人员姓名")
    @SaturnColumn(description = "人员姓名 人员姓名")
    private String realName;

    @ApiModelProperty("职位编码 职位编码")
    @SaturnColumn(description = "职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    @SaturnColumn(description = "职位名称 职位名称")
    private String posName;

    @ApiModelProperty("所属组织编码 所属组织编码")
    @SaturnColumn(description = "所属组织编码 所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称 所属组织名称")
    @SaturnColumn(description = "所属组织名称 所属组织名称")
    private String orgName;

}