package com.biz.crm.nebular.tpm.liqueuraudit.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * J酒类TPM核销申请资料表;返回vo
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "J酒类TPM核销申请资料表;")
@SaturnEntity(name = "TpmLiqueurAuditFileRespVo", description = "J酒类TPM核销申请资料表;")
public class TpmLiqueurAuditFileRespVo extends CrmExtVo {
    @ApiModelProperty("核销申请编码")
    @SaturnColumn(description = "核销申请编码")
    private String auditCode;

    @ApiModelProperty("核销申请明细编码")
    @SaturnColumn(description = "核销申请明细编码")
    private String auditDetailCode;

    @ApiModelProperty("核销申请资料类型(1,核销资料,2,活动取证资料,3,审批资料)")
    @SaturnColumn(description = "核销申请资料类型(1,核销资料,2,活动取证资料,3,审批资料)")
    private Integer auditFileType;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String fineName;

    @ApiModelProperty("描述")
    @SaturnColumn(description = "描述")
    private String fileDesc;

    @ApiModelProperty("文件地址")
    @SaturnColumn(description = "文件地址")
    private String addressUrl;

    @ApiModelProperty("对象名称")
    @SaturnColumn(description = "对象名称")
    private String objectName;

}