package com.biz.crm.common.param;

/**
 * 全局参数key，参数值从ParamUtil中获取
 */
public class ParameterParam {

    /**
     * 下拉框返回数量key
     */
    public static final String SELECT_BOX_OPTION_SIZE = "select_box_option_size";

    /**
     * Y/N 客户用户是否可以关联多个客户，Y表示可以关联多个，N表示最多只能关联一个
     */
    public static final String USER_CAN_RELATION_MANY_CUSTOMER = "user_can_relation_many_customer";

    /**
     * Y/N 终端用户是否可以关联多个终端，Y表示可以关联多个，N表示最多只能关联一个
     */
    public static final String USER_CAN_RELATION_MANY_TERMINAL = "user_can_relation_many_terminal";

    /**
     * 行政区域级联下拉框国家下拉框显影控制 Y/N
     */
    public static final String MDM_REGION_SHOW_CONTROL_COUNTRY = "mdm_region_show_control_country";

    /**
     * 行政区域级联下拉框乡镇下拉框显影控制 Y/N
     */
    public static final String MDM_REGION_SHOW_CONTROL_TOWNSHIP = "mdm_region_show_control_township";

    /**
     * 降维编码单节长度全局参数key
     */
    public static final String TREE_REDUCTION_RULE_CODE_SPLIT_LENGTH = "tree_reduction_rule_code_split_length";

    /**
     * 登录密码错误次数
     */
    public static final String LOGIN_ERROR_FREQUENCY = "login_error_frequency";

    /**
     * 密码错误次数自动清零时间（分钟）
     */
    public static final String LOGIN_PASSWORD_ERROR_RESET_MINUTES = "login_password_error_reset_minutes";

    /**
     * 登录错误锁定时长
     */
    public static final String LOGIN_LOCK_TIME = "login_lock_time";

    /**
     * 销假是否走审批流程配置Key
     */
    public static final String SFA_LEAVE_CANCEL_AUDIT = "sfa_leave_cancel_audit";

    /**
     * sfa小程序微信与用户一一对应绑定，N：没有限制，sfa小程序只能账号密码登录，Y：微信与用户一一对应进行绑定，可以用微信自动登录
     */
    public static final String SFA_APPLET_USER_UNIQUE_FLAG = "sfa_applet_user_unique_flag";
    /**
     * app小程序报表-近段时间拜访排行展示周期key
     */
    public static final String VISIT_RANKING_CYCLE = "visit_ranking_cycle";
    public static final Integer VISIT_RANKING_CYCLE_DEFAULT_VALUE = 7;
    /**
     * app小程序报表-近段时间拜访排行前几位 key
     */
    public static final String VISIT_RANKING_TOPFEW = "visit_ranking_topfew";
    public static final Integer VISIT_RANKING_TOPFEW_DEFAULT_VALUE = 10;
    /**
     * app小程序报表-拜访与销售走势图周期月份数(月)
     */
    public static final String VISI_SALES_MONTHS = "visi_sales_months";
    public static final Integer VISI_SALES_MONTHS_DEFAULT_VALUE = 6;

    /**
     * 可购清单刷新开关，开：Y，关：N
     */
    public static final String DMS_AVAILABLE_LIST_FLUSH_SWITCH = "dms_available_list_flush_switch";


    /**
     * 价格截断
     */
    public static final String PRICE_CHUNK_CONFIG = "price_chunk_config";

    /**
     * <拜访步骤配置范围是否精确到客户细类>
     * Y/N，控制【拜访步骤配置】【新增页面】能否选择客户细类。在实际执行拜访业务时，该用户拜访步骤列表的匹配策略也受此参数影响。
     */
    public static final String SFA_VISIT_STEP_CONFIG_CLIENT_SUBCLASS_RANGE = "sfa_visit_step_config_client_subclass_range";

    /**
     * 地图数据来源
     */
    public static final String SFA_NEARBY_MAP_DATA = "sfa_nearby_map_data";

    /**
     * 是否查询行政区域
     */
    public static final String IP_RESOURCE = "IP_RESOURCE";

    /**
     * 费用池amount表示含义
     */
    public static final String FEE_POOL_AMOUNT_DESC = "fee_pool_amount_desc";


    /**
     * Y/N 生成物料信息时是否生成产品信息，Y表示可以生成产品信息，N表示不能生成产品信息
     */
    public static final String MATERIAL_CREATE_PRODUCT_AUTOMATIC = "material_create_product_automatic";


    /**
     * Y/N 生成客户信息时是否生成客户用户信息，Y表示可以生成客户用户信息，N表示不能生成客户用户信息
     */
    public static final String CUSTOMER_CREATE_CUSTOMER_USER_AUTOMATIC = "customer_create_customer_user_automatic";
    /**
     * Y/N 生成终端信息时是否生成终端用户信息，Y表示可以生成终端用户信息，N表示不能生成终端用户信息
     */
    public static final String TERMINAL_CREATE_CUSTOMER_USER_AUTOMATIC = "terminal_create_customer_user_automatic";

    public static final String ACT_PERIOD_OF_VALIDITY = "act_period_of_validity";
}
