package com.biz.crm.nebular.activiti.task.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * @author weston
 * @date 2020-11-26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "流程文件信息响应vo")
@SaturnEntity(name = "ProcessFileInfoRspVO", description = "流程文件信息响应vo")
@CrmColumnResolve
public class ProcessFileInfoRspVO {

    @ApiModelProperty(value = "标题")
    private String processTitle;

    @ApiModelProperty(value = "流程Key")
    private String processKey;

    @ApiModelProperty(value = "流程名称")
    private String processName;

    @ApiModelProperty(value = "流程实例id")
    private String processInstanceId;

    @ApiModelProperty(value = "流程提交文件")
    List<TaActFileRespVo> startFiles;

    @ApiModelProperty(value = "详情")
    private String activityRemarks;
}
