package com.biz.crm.nebular.dms.availablegoods;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "可购商品vo")
public class AvailableGoodsVo extends CrmExtTenVo {
    /**
     * 合同编码
     */
    @ApiModelProperty("合同编码")
    private String saleContractCode;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String code;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String name;
    /**
     * 产品层级
     */
    @ApiModelProperty("产品层级")
    private String layer;
    /**
     * 产品规格
     */
    @ApiModelProperty("产品规格")
    private String standard;
    /**
     * 所有的可购商品详情
     */
    @ApiModelProperty("所有的可购商品详情")
    private List<AvailableGoodsVo> voList;
}
