package com.biz.crm.nebular.dms.npromotion.vo;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.dms.npromotion.bo.LimitedResultBo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.util.CommonConstant;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 促销编辑vo
 * @Author: chenrong
 * @Date: 2021/4/12 17:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PromotionEditVo extends CrmExtVo {

  private static final long serialVersionUID = 3885879377957562926L;

  /**
   * 促销编码
   */
  private String promotionPolicyCode;

  /**
   * 促销名称
   */
  private String promotionPolicyName;

  /**
   * 促销政策模板模板id
   */
  @ApiModelProperty(value = "促销政策模板模板id")
  private String templateId;

  /**
   * 促销政策模板模板code
   */
  @ApiModelProperty(value = "促销政策模板模板编码")
  private String templateCode;

  /**
   * 促销政策模板模板name
   */
  @ApiModelProperty(value = "促销政策模板模板名称")
  private String templateName;

  /**
   * 有效期开始
   */
  @ApiModelProperty(value = "有效期开始-时间")
  private String beginTime;


  /**
   * 有效期结束
   */
  @ApiModelProperty(value = "有效期结束-时间")
  private String endTime;


  /**
   * 政策叠加 字典：yesOrNo
   */
  @ApiModelProperty(value = "政策叠加 字典：yesOrNo")
  private String multipleable = CommonConstant.GLOBAL.YesOrNo.Y.getItemCode();

  @ApiModelProperty(value = "政策叠加字典翻译 字典：yesOrNo")
  @CrmDict(typeCode = "yesOrNo",dictCodeField = "multipleable")
  private String multipleableName;
  /**
   * 首单享受 字典：yesOrNo
   */
  @ApiModelProperty(value = "首单享受 字典：yesOrNo")
  private String firstOrder;

  @ApiModelProperty(value = "首单享受字典翻译 字典：yesOrNo")
  @CrmDict(typeCode = "yesOrNo",dictCodeField = "firstOrder")
  private String firstOrderName;
  /**
   * 促销描述
   */
  @ApiModelProperty(value = "促销描述")
  private String description;

  /**
   * 商品组合起订量
   */
  @ApiModelProperty(value = "商品组合起订量")
  private BigDecimal productsOrderQty;

  /**
   * 组合起订量类型
   */
  @ApiModelProperty(value = "组合起订量类型")
  private String productsOrderQtyType;

  @ApiModelProperty(value = "组合起订量类型字典翻译")
  @CrmDict(typeCode = "products_order_qty_type",dictCodeField = "productsOrderQtyType")
  private String productsOrderQtyTypeName;

  /**
   * 活动规划行号
   */
  @ApiModelProperty(value = "活动规划行号")
  private String actPlanNo;

  /**
   * 费率
   */
  @ApiModelProperty(value = "费率")
  private BigDecimal feeRate;
  /**
   * 渠道
   */
  @ApiModelProperty(value = "渠道")
  private String chanel;
  /**
   * 销售公司编码
   */
  @ApiModelProperty(value = "销售公司编码")
  private String saleCompanyCode;
  /**
   * 销售公司
   */
  @ApiModelProperty(value = "销售公司")
  private String saleCompanyName;

  /**
   * 政策使用量上限
   */
  @ApiModelProperty(value = "政策使用量上限")
  private BigDecimal usedQtyUpper;

  /**
   * 促销类型 字典：promotion_type
   */
  @ApiModelProperty(value = "促销类型")
  private String promotionType;

  /**
   * 销售范围类型，customer:经销商，terminal:终端，默认经销商
   */
  @ApiModelProperty(value = "销售范围类型，customer:经销商，terminal:终端")
  private String scopeType = "customer";

  @ApiModelProperty(value = "促销商品，key-currents：本品，key-gifts：赠品", hidden = true)
  private Map<String, List<PromotionProductVo>> productMap = Maps.newHashMap();

  @ApiModelProperty(value = "促销规则，key-conditions：条件规则，key-calculates：计算规则，key-limiteds：限量规则", hidden = true)
  private Map<String, List<PromotionRuleVo>> ruleMap = Maps.newHashMap();

  @ApiModelProperty(value = "促销范围，key-cuss：客户，key-orgs：组织，key-terminal：终端，key-channels：渠道", hidden = true)
  private Map<String, List<PromotionScopeVo>> scopeMap = Maps.newHashMap();

  @ApiModelProperty(value = "模板数据")
  private PromotionPolicyTemplateVo templateVo;

  @ApiModelProperty(value = "促销政策阶梯计算结果对象")
  private CalculateHitResultVo calculateHitResultVo;

  @ApiModelProperty(value = "是否本品组合政策")
  private boolean composeState;

  @ApiModelProperty(value = "促销政策匹配结果")
  private boolean matchState;

  @ApiModelProperty(value = "促销政策查询结果描述")
  private String matchMsg;

  @ApiModelProperty(value = "是否不展示到前端")
  private Integer notShow = 0;

  @ApiModelProperty(value = "父级促销政策编码")
  private String parentCode;

  /**    审批相关  **/
  @ApiModelProperty(value = "审批状态(数据字典bpm_status)")
  private String bpmStatus;
  @ApiModelProperty(value = "流程编号")
  private String crmProcessInstanceId;
  @ApiModelProperty(value = "流程提交时间")
  private String bpmSubmitDate;
  @ApiModelProperty(value = "流程通过时间")
  private String bpmPassDate;
  @ApiModelProperty(value = "提交人")
  private String bpmSubmitBy;

  /** 活动相关  **/
  @ApiModelProperty(value = "活动编码")
  private String budgetCode;

  @ApiModelProperty(value = "预算科目编码")
  private String projectCode;

  @ApiModelProperty(value = "预算科目名称")
  private String projectName;

  @ApiModelProperty(value = "活动可用余额")
  private BigDecimal availableFee;

  @ApiModelProperty(value = "申请金额")
  private BigDecimal applyFee;

  @ApiModelProperty(value = "限量规则计算结果")
  private List<LimitedResultBo> limitedResultBos;
}
