package com.biz.crm.nebular.dms.npromotion.vo;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 商品购买信息
 * @Author: chenrong
 * @Date: 2021/4/16 11:27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("商品购买信息")
public class PromotionSaleProductVo extends CrmExtTenVo {

  private static final long serialVersionUID = -684022205476809450L;

  @ApiModelProperty(value = "商品编码", required = true)
  private String productCode;

//  @ApiModelProperty(value = "促销编码", required = true)
//  private String promotionCode;

  @ApiModelProperty(value = "购买数量", required = true)
  private BigDecimal buyCount = BigDecimal.ZERO;

  @ApiModelProperty(value = "购买金额", required = true)
  private BigDecimal buyAmount = BigDecimal.ZERO;

  @ApiModelProperty(value = "价格", required = true)
  private BigDecimal price = BigDecimal.ZERO;
}
