package com.biz.crm.nebular.dms.promotion;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 促销编辑vo
 * @Author: chenrong
 * @Date: 2021/4/12 17:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PromotionInfoRespVo extends CrmExtVo {

  private static final long serialVersionUID = 3885879377957562926L;

  /**
   * 促销编码
   */
  private String promotionPolicyCode;

  /**
   * 促销名称
   */
  private String promotionPolicyName;

  /**
   * 有效期开始
   */
  @ApiModelProperty(value = "有效期开始-时间")
  private String beginTime;

  /**
   * 有效期结束
   */
  @ApiModelProperty(value = "有效期结束-时间")
  private String endTime;

  /**
   * 促销描述
   */
  @ApiModelProperty(value = "促销描述")
  private String description;

  /**
   * 费率
   */
  @ApiModelProperty(value = "费率")
  private BigDecimal feeRate;
  /**
   * 渠道
   */
  @ApiModelProperty(value = "渠道")
  private String chanel;
  /**
   * 销售公司编码
   */
  @ApiModelProperty(value = "销售公司编码")
  private String saleCompanyCode;
  /**
   * 销售公司
   */
  @ApiModelProperty(value = "销售公司")
  private String saleCompanyName;

  /**
   * 政策使用量上限
   */
  @ApiModelProperty(value = "政策使用量上限")
  private BigDecimal usedQtyUpper;

  /**
   * 促销类型 字典：promotion_type
   */
  @ApiModelProperty(value = "促销类型")
  private String promotionType;

  /**
   * 销售范围类型，customer:经销商，terminal:终端，默认经销商
   */
  @ApiModelProperty(value = "销售范围类型，customer:经销商，terminal:终端")
  private String scopeType = "customer";

  @ApiModelProperty(value = "促销政策范围集合")
  private List<PromotionPolicyScopeVo> scopeList;


}
