package com.biz.crm.nebular.dms.promotion;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author xi.peng
 */
@ApiModel(value = "促销政策编码请求参数")
@Data
public class PromotionPolicyProductRespVo extends CrmExtVo implements Serializable {

    @ApiModelProperty(value = "商品编码")
    private String productCode;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "本品赠品一一对应-赠品编码")
    private String productCodeGift;

    @ApiModelProperty(value = "本品赠品一一对应-赠品名称")
    private String productNameGift;

    @ApiModelProperty(value = "本品赠品")
    private String currentProduct;

    @ApiModelProperty(value = "单品起订量类型 字典：products_order_qty_type")
    private String productOrderQtyType;

    @ApiModelProperty(value = "单品起订量")
    private BigDecimal productOrderQty;

    @ApiModelProperty(value = "政策id")
    private String promotionPolicyId;

    @ApiModelProperty(value = "政策code")
    private String promotionPolicyCode;

    @ApiModelProperty(value = "政策名称")
    private String promotionPolicyName;

}
