package com.biz.crm.nebular.dms.salecontract;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 合同模板元组映射vo
 * @Author: chenrong
 * @Date: 2021/2/5 11:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同模板元组映射vo")
public class ContractTemplateTupleMappingVo extends CrmExtTenVo {

  private static final long serialVersionUID = 8222387617459990542L;

  /**
   * 合同模板编码
   */
  @ApiModelProperty(value = "合同模板编码")
  private String templateCode;
  /**
   * 合同元组编码
   */
  @ApiModelProperty(value = "合同元组编码")
  private String tupleCode;
  /**
   * 元组再模板中展示顺序
   */
  @ApiModelProperty(value = "元组再模板中展示顺序")
  private Integer tupleIndex;
  /**
   * 数据对象名称
   */
  @ApiModelProperty(value = "数据对象名称")
  private String jsonName;
  /**
   * 数据对象
   */
  @ApiModelProperty(value = "数据对象")
  private JSONObject JsonData;
  /**
   * 数据检索编码
   */
  @ApiModelProperty(value = "数据检索编码")
  private String indexCode;
}
