package com.biz.crm.nebular.fee.capital;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.ArrayList;

/**
 * @Author: huojia
 * @DateTime: 2021/1/28 19:05
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "资金流水vo")
public class CapitalFlowVo extends CrmExtVo {

    @ApiModelProperty(value = "资金池编码")
    private String capitalCode;

    @ApiModelProperty(value = "流水号")
    private String flowNo;

    @ApiModelProperty(value = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户sap编码")
    private String cusSapCode;

    @ApiModelProperty(value = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "客户组织编码")
    private String cusOrgCode;

    @ApiModelProperty(value = "客户组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "客户所属公司编码")
    private String companyCode ;

    @ApiModelProperty(value = "客户所属公司名称")
    private String companyName;

    @ApiModelProperty(value = "调整原因（字典）")
    private String adjustReson;

    @ApiModelProperty(value = "调整类型（字典）")
    private String adjustType;

    @ApiModelProperty(value = "单据类型（字典）")
    private String billType;

    @ApiModelProperty(value = "单据号")
    private String billNo;

    @ApiModelProperty(value = "操作金额")
    private BigDecimal adjustMoney;

    //--------授信
    @ApiModelProperty(value = "授信总额")
    private BigDecimal creditTotal;

    @ApiModelProperty(value = "授信已经使用额")
    private BigDecimal creditUsedTotal;

    @ApiModelProperty(value = "授信总余额")
    private BigDecimal creditSurplusTotal;

    @ApiModelProperty(value = "授信冻结额")
    private BigDecimal creditFrozeMoney;

    @ApiModelProperty(value = "授信可用额")
    private BigDecimal creditAbleTotal;


    //--------资金
    @ApiModelProperty(value = "资金已使用额")
    private BigDecimal capitalUsedTotal;

    @ApiModelProperty(value = "资金总余额")
    private BigDecimal capitalSurplusTotal;

    @ApiModelProperty(value = "资金冻结额")
    private BigDecimal capitalFrozeMoney;

    @ApiModelProperty(value = "资金可用余额")
    private BigDecimal capitalAbleTotal;

    @ApiModelProperty(value = "冻结总额")
    private BigDecimal frozeMoney;


    @ApiModelProperty(value = "文件列表")
    private ArrayList<CapitalFlowFileVo> files;
}