package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 客户费用池金额汇总查询返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户费用池金额汇总查询返回vo")
@CrmColumnResolve
public class FeePoolMonthAmountRespVo {

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("年月 yyyy-MM")
    private String yearMonth;

    @ApiModelProperty("总共剩余可用余额（与月份无关）")
    private BigDecimal usableAmount;

    @ApiModelProperty("截至本月剩余可用余额")
    private BigDecimal thisMonthUsableAmount;

    @ApiModelProperty("本月内上账费用总额")
    private BigDecimal thisMonthAccountAmount;

    @ApiModelProperty("截至上月剩余可用余额")
    private BigDecimal lastMonthUsableAmount;

    @ApiModelProperty("本月内使用费用")
    private BigDecimal thisMonthHasUseAmount;

}