package com.biz.crm.nebular.kms.acceptanceform.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 验收单原始单据详情返回vo
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "验收单原始单据详情")
public class KmsAcceptanceGoodsRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 459908002766821578L;
    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("抓单生成的验收单编号")
    private String orderNumber;

    @ApiModelProperty("商超验收单编号")
    private String kaOrderNumber;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("单据当前状态")
    private String orderStatus;

    @ApiModelProperty("单据当前状态信息")
    private String orderStatusMsg;
    /**
     * 关联ID(企业商品与商超商品表ID)
     */
    @ApiModelProperty("关联ID(企业商品与商超商品表ID)")
    private String goodsRelatedId;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("当前单位验收数量")
    private String curUnitAcceptanceQuantity;

    @ApiModelProperty("当前单位")
    private String curUnit;

    @ApiModelProperty("单位转换比例系数")
    private BigDecimal ratio;

    /**
     * 企业单位数量
     */
    @ApiModelProperty("企业单位数量")
    private BigDecimal numerator;

    @ApiModelProperty("企业当前单位")
    private String curCompanyUnit;

    @ApiModelProperty("企业当前单位订货数量")
    private String curCompanyUnitOrderQuantity;

    @ApiModelProperty("当前单位层级")
    private String curUnitLevel;

    @ApiModelProperty("最小单位验收数量")
    private String minUnitAcceptanceQuantity;

    @ApiModelProperty("最小单位")
    private String minUnit;

    @ApiModelProperty("最小单位层级")
    private String minUnitLevel;

    @ApiModelProperty("最大单位验收数量")
    private String maxUnitAcceptanceQuantity;

    @ApiModelProperty("最大单位")
    private String maxUnit;

    @ApiModelProperty("最大单位层级")
    private String maxUnitLevel;

    @ApiModelProperty("订货数量")
    private String orderQuantity;

    @ApiModelProperty("订货金额小计（含税）")
    private String orderAmount;

    @ApiModelProperty("验收金额小计（含税）")
    private String acceptanceAmount;

    @ApiModelProperty("订货金额小计（不含税）")
    private String orderAmountNot;

    @ApiModelProperty("验收金额小计（不含税）")
    private String acceptanceAmountNot;

    @ApiModelProperty("字段转换标识：0失败，1成功")
    private String transStatus;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("行信息排序")
    private Integer itemIndex;
}