package com.biz.crm.nebular.kms.confadmin.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * kms抓单接口参数请求vo
 *
 * @author Gavin
 * @date 2021-05-07 10:20:19
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsInterfaceParamReqVo", description = "kms抓单接口参数")
public class KmsInterfaceParamReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -6635587826040572343L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("单据类型编码")
    private String orderType;

    @ApiModelProperty("参数属性名")
    private String fieldEn;

    @ApiModelProperty("参数文本名")
    private String fieldCn;

    @ApiModelProperty("控件类型 数据字典：kms_field_classify")
    private String fieldClassify;

    @ApiModelProperty("参数类型 数据字典：kms_param_classify")
    private String paramClassify;

    @ApiModelProperty("提示文字")
    private String promptText;

    @ApiModelProperty("字段是否必填(YES/NO) 数据字典：kms_interface_param_required")
    private String isRequired;

    @ApiModelProperty("是否显示（0：显示，1：不显示）数据字典：kms_interface_param_show")
    private String isShow;

    @ApiModelProperty("字段排序")
    private Integer sortIndex;

    @ApiModelProperty("查询条件（0：不是筛选字段，1：是筛选字段）")
    private String isScreen;

    /**
     * 下拉单选或下拉多选选项列表
     */
    private List<KmsInterfaceParamOptionReqVo> options;

    /**
     * 子参数列表
     */
    private List<KmsInterfaceSubParamOptionReqVo> subOptions;
}