package com.biz.crm.nebular.kms.finance.req;

import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 稽核数据请求vo
 *
 * @author Gavin
 * @date 2021-05-27 11:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsAuditFormReqVo", description = "稽核数据")
public class KmsAuditFormReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -8896964965878601489L;
    @ApiModelProperty("稽核单ID集合")
    private List<String> ids;

    @ApiModelProperty("验收单Id")
    private String acceptanceId;

    @ApiModelProperty("SAP发票号")
    private String sapVbeln;

    @ApiModelProperty("稽核单号")
    private String auditNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("公司代码")
    private String bukrs;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    /**
     * 直营体系Id
     */
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    private List<String> bsDirectSystemIds;

    /**
     * 直营体系编码
     */
    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("商超名称")
    private String directName;

    @ApiModelProperty("匹配结果")
    private String auditResult;

    @ApiModelProperty("sap过账日期")
    private String sapPostingDate;

    @ApiModelProperty("sap过账日期集合")
    private List<String> sapPostingDateList;

    @ApiModelProperty("送达方编号")
    private String storeCode;

    @ApiModelProperty("送达方名称")
    private String storeName;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("SAP物料号")
    private String sapMaterielCode;

    @ApiModelProperty("SAP物料号集合")
    private List<String> sapMaterielCodeList;

    @ApiModelProperty("SAP物料名称")
    private String sapMaterielName;

    @ApiModelProperty("SAP数量")
    private String sapQuantity;

    @ApiModelProperty("验收数量")
    private String acceptanceQuantity;

    @ApiModelProperty("数量差异")
    private String compareQuantity;

    @ApiModelProperty("SAP总金额（不含税）")
    private String sapAmountNot;

    @ApiModelProperty("验收金额（不含税）")
    private String acceptanceAmountNot;

    @ApiModelProperty("SAP总金额（含税）")
    private String sapAmount;

    @ApiModelProperty("验收金额（含税）")
    private String acceptanceAmount;

    @ApiModelProperty("验收金额（含税）")
    private String compareAmount;

    @ApiModelProperty("配送商")
    private String distributor;

    @ApiModelProperty("完成日期")
    private String completionDate;

    @ApiModelProperty("完成人")
    private String rinisher;

    @ApiModelProperty("稽核模版ID")
    private String auditTemplateId;

    @ApiModelProperty("容差规则（正_Z/负_F/上下浮动_UD）")
    private String auditRule;

    @ApiModelProperty("价格允差")
    private BigDecimal differencePrice;

    /**
     * 对账匹配阈值（天数）
     * 匹配门店时对时间进行处理
     */
    @ApiModelProperty("对账匹配阈值（天数）")
    private Integer timeOfDay;

    @ApiModelProperty("商品类型")
    private String productType;

    @ApiModelProperty("稽核状态(待确认/已确认)")
    private String auditStatus;

    @ApiModelProperty("验收开始时间")
    private String acceptanceDateEnd;

    @ApiModelProperty("验收结束时间")
    private String acceptanceDateStart;

    @ApiModelProperty("抓单生成的验收单编号")
    private String orderNumber;

    @ApiModelProperty("企业验收单号")
    private String acceptanceComNumber;

    @ApiModelProperty("企业验收单号集合")
    private List<String> acceptanceComNumberList;

    /**
     * 是否稽核
     */
    @ApiModelProperty("是否稽核yes/no")
    private String isAudit;

    @ApiModelProperty("选中验收单集合")
    private List<KmsAuditAcceptanceFormRespVo> acceptanceFormVos;

    @ApiModelProperty("sap过账开始日期")
    private String sapPostingDateStart;

    @ApiModelProperty("sap过账结束日期")
    private String sapPostingDateEnd;

    @ApiModelProperty("sap订单号")
    private List<String> bstkdList;

    @ApiModelProperty("排序方式")
    private String desc = "DESC";
}