package com.biz.crm.nebular.kms.finance.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 稽核模板返回vo
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "稽核模板")
public class KmsAuditTemplateRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -3698926430837093229L;
    @ApiModelProperty("稽核模版名称")
    private String templateName;

    @ApiModelProperty("稽核单据类型")
    private List<String> orderTypeList;

    @ApiModelProperty("稽核条件")
    private List<String> conditionList;

    @ApiModelProperty("稽核单据类型")
    private String orderTypeArray;

    @ApiModelProperty("稽核条件")
    private String conditionArray;

    @ApiModelProperty("SAP企业代码")
    private String sapOrgCode;

    @ApiModelProperty("SAP企业代码")
    private String orgCode;

    @ApiModelProperty("商超ID")
    private String directId;

    /**
     * 直营体系Id
     */
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;


    /**
     * 直营体系编码
     */
    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    /**
     * 对账匹配阈值（天数）
     * 匹配门店时对时间进行处理
     */
    @ApiModelProperty("对账匹配阈值（天数）")
    private Integer timeOfDay;

    @ApiModelProperty("商超信息")
    private List<KmsAuditTemplateDirectRespVo> directVos;
}