package com.biz.crm.nebular.kms.grabrule.resp;

import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 抓单规则配置表返回vo
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "抓单规则配置表")
public class KmsGrabRuleRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 1874201012368371030L;

    @ApiModelProperty("商超Id")
    private String directId;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("单据类型Id")
    private String orderTypeId;

    @ApiModelProperty("单据类型编码")
    private String orderType;

    @ApiModelProperty("单据下载方式")
    private Integer orderDownloadWay;

    @ApiModelProperty("原始文件格式")
    private Integer fileClassify;

    @ApiModelProperty("文件下载方式")
    private Integer fileDownloadWay;

    @ApiModelProperty("抓单规则名称")
    private String ruleName;

    @ApiModelProperty("登录账号ID")
    private String accountId;

    @ApiModelProperty("作用门店是否选择全部标识(Y/N)")
    private String isAllStore;

    @ApiModelProperty("开始时间(正整数)")
    private Integer startTime;

    @ApiModelProperty("结束时间(正整数)")
    private Integer endTime;

    @ApiModelProperty("时间间隔(正整数)")
    private Integer intervalTime;

    @ApiModelProperty("登录账号")
    private String loginAcc;

    @ApiModelProperty("登录账号")
    private String loginPass;

    @ApiModelProperty("抓单门店")
    private List<KmsGrabRuleStoreRespVo> ruleStoreList;

    @ApiModelProperty("抓单参数")
    private List<BsGrabInterfaceParamRespVo> ruleParamList;

    /**
     * 原始数据ID
     */
    private String rawDataId;

    private String nickName = "CRM_KMS系统";
}