package com.biz.crm.nebular.mdm.availablelist;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/4/15 14:48
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "客户修改商品层级，通知可够清单的数据传输对象")
public class AvalibleListProductLevelChangeDto implements Serializable {

    /**
     * 商品编码
     */
    private String goodsCode;

    /**
     * 旧商品层级编码
     */
    private String oldLevelCode;

    /**
     * 旧商品层级名称
     */
    private String oldLevelName;

    /**
     * 新商品层级编码
     */
    private String newLevelCode;

    /**
     * 新商品层级名称
     */
    private String newLevelName;


    /**
     * 初始化静态方法
     * @param goodsCode
     * @return
     */
    public static AvalibleListProductLevelChangeDto newInstance(String goodsCode){
        return new AvalibleListProductLevelChangeDto();
    }

    /**
     * 旧lecel信息
     * @param oldLevelCode
     * @param oldLevelName
     * @return
     */
    public AvalibleListProductLevelChangeDto oldLevel(String oldLevelCode,String oldLevelName){
        this.setOldLevelCode(oldLevelCode);
        this.setOldLevelName(oldLevelName);
        return this;
    }

    /**
     * 新lecel信息
     * @param newLevelCode
     * @param newLevelName
     * @return
     */
    public AvalibleListProductLevelChangeDto newLevel(String newLevelCode,String newLevelName){
        this.setNewLevelCode(newLevelCode);
        this.setNewLevelName(newLevelName);
        return this;
    }
}
