package com.biz.crm.nebular.mdm.cusorg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 客户组织表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerOrgSelectReqVo", description = "客户组织下拉选择条件")
public class MdmCustomerOrgSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("客户组织编码：模糊查询客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称：模糊查询客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("客户组织编码，查询这个组织的直接下级")
    private String parentCode;

    @ApiModelProperty("模糊查询客户组织编码或名称")
    private String customerOrgCodeOrName;

    @ApiModelProperty("模糊查询unionName返回字段")
    private String unionName;

    @ApiModelProperty("客户组织层级，精确查询客户组织层级")
    private String customerOrgLevel;

    @ApiModelProperty("客户组织类型，精确查询客户组织类型")
    private String customerOrgType;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;

}