package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.config.CrmColumnResolve;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "产品销售报表")
@SaturnDomain(value = "customerproductrespvo")
@SaturnEntity(name = "CustomerProductRespVo", description = "产品销售报表")
@CrmColumnResolve
public class CustomerProductRespVo {

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户组织，省区")
    @SaturnColumn(description = "客户组织")
    private String customerOrgName;

    @ApiModelProperty("所属组织名称,战区")
    @SaturnColumn(description = "所属组织名称")
    private String orgName;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "规格")
    private String spec;

    @ApiModelProperty(value = "数量")
    private BigDecimal productNum;

    @ApiModelProperty(value = "单位")
    private String salesUnitName;

    @ApiModelProperty(value = "订单金额")
    private BigDecimal amount;

    @ApiModelProperty("修改时间完整")
    private String updateDateAll;

}
