package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmCustomerMsgReqVo", description = "客户信息请求")
@Accessors(chain = true)
public class MdmCustomerMsgReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("渠道")
    private List<String> channelList;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    //产品销售报表查询使用
    @ApiModelProperty("产品名称")
    private String productName;

    //客户销售报表查询使用
    @ApiModelProperty("上月核销时间")
    private String lastTime;

    @ApiModelProperty("客户组织")
    private String customerOrgName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("操作类型")
    private String operateType;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织")
    private String orgName;

    @ApiModelProperty("市级编码")
    private String cityCode;

    @ApiModelProperty("区级编码")
    private String districtCode;

    @ApiModelProperty("省级编码")
    private String provinceCode;

    @ApiModelProperty("市名称")
    private String cityName;

    @ApiModelProperty("区名称")
    private String districtName;

    @ApiModelProperty("省名称")
    private String provinceName;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty("工程名")
    private String projectName;

    @ApiModelProperty("客户联系方式")
    private String customerContact;

    @ApiModelProperty("客户法人代表")
    private String legalRepresentative;

    @ApiModelProperty("对接人列表")
    private List<MdmCustomerDockingReqVo> mdmCustomerDockingVos;

    @ApiModelProperty("联系人列表")
    private List<MdmCustomerContactReqVo> mdmCustomerContactVos;

    @ApiModelProperty("销售区域列表")
    private List<MdmCustomerSaleAreaReqVo> mdmCustomerSaleAreaVos;

    @ApiModelProperty("客户开票信息")
    private List<MdmCustomerBillReqVo> mdmCustomerBillVos;

    @ApiModelProperty("客户编码集合")
    private List<String> customerCodeList;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodeList;

    private String code;

    @ApiModelProperty("锁定状态：009正常，003冻结")
    private String lockState;

    /**
     * 目前的逻辑是客户只能关联一个角色，所以用一个字段返回客户关联角色编码
     */
    @ApiModelProperty("关联角色编码")
    private String roleCode;

    @ApiModelProperty("用户帐号")
    @Deprecated
    private String userName;

    @Deprecated
    private String customerPrimary;

    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("erp编码")
    private String erpCode;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;

    @ApiModelProperty("价格组")
    private String priceGroup;

    @ApiModelProperty("企业组织编码集合，查询这些组织及全部下级企业组织（含当前组织）")
    private List<String> allUnderOrgCodeListIncludeSelf;

    private List<MdmCustomerTypeVo> mdmCustomerTypeVos;
    private List<MdmCustSaleCompanyVo> mdmCustSaleCompanyVos;
    @ApiModelProperty("合作状态")
    private String cooperateStatus;

    @ApiModelProperty("审批类型")
    private String approvalType;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("流程key")
    private String workFlowKey;
    @ApiModelProperty("主题")
    private String title;
    @ApiModelProperty("业务来源系统")
    private String fromType;
    @ApiModelProperty("审批备注")
    private String approveRemarks;
    @ApiModelProperty("流程文件集合")
    private List<TaActFileReqVo> activityFileList;

    @ApiModelProperty("审批配置业务编码")
    private String approvalBusinessCode;

    @ApiModelProperty("是否需要查询客户企业组织集合(Y/N)")
    private String isQueryCustomerOrgList;

    @ApiModelProperty("证件上传照片")
    private List<String> certificateImageList;

    @ApiModelProperty("法人身份上传照片")
    private List<MdmCustomerUploadVo> corporateIdentityImageList;

    /**
     * 数据字典source_type
     */
    @ApiModelProperty("数据来源")
    private String sourceType;

    @ApiModelProperty("查询：联系人电话")
    private String contactPhone;

    @ApiModelProperty("查询：联系人姓名")
    private String contactName;

    @ApiModelProperty("查询：对接用户")
    private String supplyUserName;

    @ApiModelProperty("查询：创建时间")
    private String startCreateDate;

    @ApiModelProperty("查询：创建时间")
    private String endCreateDate;
}