package com.biz.crm.nebular.mdm.dict.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 数据字典扩展字段配置表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmDictAttrConfReqVo", description = "数据字典扩展字段配置表")
public class MdmDictAttrConfReqVo extends CrmBaseVo {

    @ApiModelProperty("数据字典类型编码")
    private String dictTypeCode;

    @ApiModelProperty("字段编码")
    private String fieldCode;

    @ApiModelProperty("字段显示名称")
    private String fieldName;

    @ApiModelProperty("对应data表扩展字段")
    private String extField;

    @ApiModelProperty("是否必填 0否 1是")
    private String required;

    @ApiModelProperty("显示顺序")
    private String showOrder;

    @ApiModelProperty("下拉框数据字典")
    private String selectDictTypeCode;

    @ApiModelProperty("下拉框单选限制，1单选，0多选")
    private String selectSingleOnly;

}