package com.biz.crm.nebular.mdm.terminal;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Liao Hua
 * @date 2020/9/3 11:18 上午
 */
@Data
@EqualsAndHashCode(callSuper = false)
@CrmColumnResolve
public class MdmTerminalContactPageVo extends CrmTreeVo {

    @ApiModelProperty("终端编码")
    private String terminalCode;
    @ApiModelProperty("终端名称")
    private String terminalName;
    @ApiModelProperty("终端类型")
    private String terminalType;
    @ApiModelProperty("终端类型")
    @CrmDict(typeCode = DictConstant.TERMINAL_TYPE, dictCodeField = "terminalType")
    private String terminalTypeName;
    @ApiModelProperty("所属组织编码")
    private String orgCode;
    @ApiModelProperty("所属组织名字")
    private String orgName;
    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;
    @ApiModelProperty("渠道")
    private String channel;
    @ApiModelProperty("渠道名字")
    private String channelName;
    @ApiModelProperty("营业执照法人姓名")
    private String licensePersonName;
    @ApiModelProperty("营业执照注册号")
    private String licenseRegisterNumber;
    @ApiModelProperty("营业执照企业名称")
    private String licenseFirmName;
    @ApiModelProperty("终端地址")
    private String terminalAddress;
    @ApiModelProperty("省编码")
    private String provinceCode;
    @ApiModelProperty("市编码")
    private String cityCode;
    @ApiModelProperty("区编码")
    private String districtCode;
    @ApiModelProperty("店招照片")
    private String shopImagePath;
    @ApiModelProperty("营业执照照片")
    private String licenseImagePath;
    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;
    @ApiModelProperty("联系人姓名")
    private String contactName;
    @ApiModelProperty("联系人电话")
    private String contactPhone;
    @ApiModelProperty("客户分类")
    private String customerClassification;
    @ApiModelProperty("限制距离")
    private Long distance;
    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;

    @ApiModelProperty("审批状态名称")
    @CrmDict(typeCode = "bpm_status",dictCodeField = "actApproveStatus")
    private String actApproveStatusName;

    @ApiModelProperty("拜访标签")
    private String visitLabel;
}
