package com.biz.crm.nebular.mdm.terminal;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author Liao Hua
 * @date 2020/9/3 11:18 上午
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@CrmColumnResolve
public class MdmTerminalVo extends CrmTreeVo {

    @ApiModelProperty("高德地图ID")
    private String amapId;


    @ApiModelProperty("门店编码查询条件")
    private List<String> terminalCodeList;
    @ApiModelProperty("左侧组织查询编码")
    private String code;
    @ApiModelProperty("左侧组织查询编码集合")
    private List<String> orgCodeList;
    @ApiModelProperty("终端编码")
    private String terminalCode;
    @ApiModelProperty("终端名称")
    private String terminalName;
    @ApiModelProperty("终端类型")
    private String terminalType;
    @ApiModelProperty("终端类型名称")
    @CrmDict(typeCode = DictConstant.TERMINAL_TYPE,dictCodeField = "terminalType")
    private String terminalTypeName;
    @ApiModelProperty("所属组织编码")
    private String orgCode;
    @ApiModelProperty("所属组织名字")
    private String orgName;
    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;
    @ApiModelProperty("客户组织名称")
    private String customerOrgName;
    @ApiModelProperty("渠道")
    private String channel;
    @ApiModelProperty("渠道名字")
    @CrmDict(typeCode = DictConstant.CHANNEL,dictCodeField = "channel")
    private String channelName;
    @ApiModelProperty("营业执照法人姓名")
    private String licensePersonName;
    @ApiModelProperty("营业执照注册号")
    private String licenseRegisterNumber;
    @ApiModelProperty("营业执照企业名称")
    private String licenseFirmName;
    @ApiModelProperty("终端地址")
    private String terminalAddress;
    @ApiModelProperty("省编码")
    private String provinceCode;
    @ApiModelProperty("市编码")
    private String cityCode;
    @ApiModelProperty("区编码")
    private String districtCode;
    @ApiModelProperty("省名称")
    private String provinceName;
    @ApiModelProperty("市名称")
    private String cityName;
    @ApiModelProperty("区名称")
    private String districtName;
    @ApiModelProperty("店招照片")
    private String shopImagePath;
    @ApiModelProperty("营业执照照片")
    private String licenseImagePath;
    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;
    @ApiModelProperty("客户分类")
    private String customerClassification;
    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;
    @ApiModelProperty("审批状态名称")
    @CrmDict(typeCode = "bpm_status",dictCodeField = "actApproveStatus")
    private String actApproveStatusName;

    @ApiModelProperty("联系人信息集合")
    private List<MdmTerminalContactVo> contacts;
    @ApiModelProperty("供货关系集合")
    private List<MdmTerminalSupplyVo> supplys;
    @ApiModelProperty("合作状态")
    private String cooperateStatus;

    @ApiModelProperty("kms关联客户门店id")
    private String storeId;

    @ApiModelProperty("kms直营体系id")
    private String directSystemId;

    @ApiModelProperty("kms售达方id")
    private String sellPartyId;

    @ApiModelProperty("审批类型")
    private String approvalType;
    @ApiModelProperty("流程编号")
    private String processCode;
    @ApiModelProperty("流程key")
    private String workFlowKey;
    @ApiModelProperty("主题")
    private String title;
    @ApiModelProperty("业务来源系统")
    private String fromType;
    @ApiModelProperty("审批备注")
    private String approveRemarks;
    @ApiModelProperty(value = "流程文件集合")
    private List<TaActFileReqVo> activityFileList;
    @ApiModelProperty(value = "审批配置业务编码")
    private String approvalBusinessCode;

    @ApiModelProperty("渠道编码集合")
    private List<String> channelList;
    @ApiModelProperty("终端关联组织集合")
    private List<MdmOrgRespVo> orgList;

    /**
     * 数据字典source_type
     */
    @ApiModelProperty("数据来源")
    private String sourceType;
    @ApiModelProperty("查询：联系人名称")
    private String contactName;
    @ApiModelProperty("查询：联系人电话")
    private String contactPhone;
    @ApiModelProperty("查询：对接用户")
    private String supplyUserName;
    @ApiModelProperty("查询：创建时间")
    private String startCreateDate;
    @ApiModelProperty("查询：创建时间")
    private String endCreateDate;

    @ApiModelProperty("标签名称")
    private String tagName;

    @ApiModelProperty("不包含门店编码查询条件")
    private List<String> notIncludeTerminalCodeList;

}
