package com.biz.crm.nebular.mdm.user.req;

import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户信息表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户-企业用户关联职位")
public class MdmUserPositionEditReqVo extends UuidVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位 0否1是")
    private String primaryFlag;

    @ApiModelProperty("操作类型 n:新建职位；h:已有职位")
    private String operationType;

    @ApiModelProperty("职位关联角色")
    private List<String> roleList;

    @ApiModelProperty("职位关联流程角色")
    private List<String> bpmRoleList;

}